/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.animal;

import java.util.List;
import java.util.UUID;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRBannerProtection;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.LOTRMountFunctions;
import lotr.common.entity.LOTRRandomSkinEntity;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide2;
import lotr.common.entity.animal.LOTREntityHorse;
import lotr.common.fac.LOTRAlignmentValues;
import lotr.common.fac.LOTRFaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class LOTREntityRam
extends LOTREntityHorse
implements LOTRRandomSkinEntity {
    public LOTREntityRam(World world) {
        super(world);
        this.func_70105_a(1.1f, 1.3f);
    }

    @Override
    public void setUniqueID(UUID uuid) {
        this.field_96093_i = uuid;
    }

    @Override
    protected boolean isMountHostile() {
        return true;
    }

    public int func_70627_aG() {
        return 500;
    }

    @Override
    protected EntityAIBase createMountAttackAI() {
        return new LOTREntityAIAttackOnCollide2((EntityCreature)this, 1.2, true);
    }

    public int func_110265_bP() {
        return 0;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70143_R > 0.0f) {
            this.field_70143_R = 0.0f;
        }
        if (this.field_70153_n instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)this.field_70153_n;
            if (!entityplayer.field_70170_p.field_72995_K && this.isMountSaddled()) {
                LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.rideRam);
            }
        }
        if (this.field_70153_n instanceof EntityLivingBase) {
            EntityLivingBase momentum = (EntityLivingBase)this.field_70153_n;
            float momentum1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            if (momentum1 > 0.2f) {
                this.func_70031_b(true);
            } else {
                this.func_70031_b(false);
            }
            if (momentum1 >= 0.32f) {
                float strength = momentum1 * 15.0f;
                Vec3 look = this.func_70040_Z();
                float sightWidth = 1.0f;
                double range = 0.5;
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72331_e(1.0, 1.0, 1.0).func_72321_a(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range).func_72314_b((double)sightWidth, (double)sightWidth, (double)sightWidth));
                boolean hitAnyEntities = false;
                for (Object obj : list) {
                    EntityLiving entityliving;
                    boolean flag;
                    EntityLivingBase entity;
                    if (!(obj instanceof EntityLivingBase) || (entity = (EntityLivingBase)obj) instanceof LOTREntityRam || entity == momentum || momentum instanceof EntityPlayer && !LOTRMod.canPlayerAttackEntity((EntityPlayer)momentum, entity, false) || momentum instanceof EntityCreature && !LOTRMod.canNPCAttackEntity((EntityCreature)momentum, entity, false) || !(flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), strength))) continue;
                    float knockback = strength * 0.1f;
                    entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockback), (double)knockback, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockback));
                    hitAnyEntities = true;
                    if (!(entity instanceof EntityLiving) || (entityliving = (EntityLiving)entity).func_70638_az() != this) continue;
                    entityliving.func_70661_as().func_75499_g();
                    entityliving.func_70624_b(momentum);
                }
                if (hitAnyEntities) {
                    this.field_70170_p.func_72956_a((Entity)this, "lotr:troll.ologHai_hammer", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
            }
        } else if (this.func_70638_az() != null) {
            float var17 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            if (var17 > 0.2f) {
                this.func_70031_b(true);
            } else {
                this.func_70031_b(false);
            }
        } else {
            this.func_70031_b(false);
        }
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityplayer) {
        if (!this.field_70170_p.field_72995_K && LOTRBannerProtection.isProtected(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, LOTRBannerProtection.forPlayer(entityplayer, LOTRBannerProtection.Permission.FOOD), true)) {
            return true;
        }
        ItemStack heldItem = entityplayer.func_70694_bm();
        if (heldItem != null && this.func_70877_b(heldItem) && this.func_70874_b() == 0 && !this.func_70880_s() && this.func_110248_bS()) {
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                --heldItem.field_77994_a;
                if (heldItem.field_77994_a <= 0) {
                    entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
                }
            }
            this.func_146082_f(entityplayer);
            return true;
        }
        if (LOTRMountFunctions.interact(this, entityplayer)) {
            return true;
        }
        boolean prevInLove = this.func_70880_s();
        LOTRFaction[] factions = new LOTRFaction[]{LOTRFaction.DURINS_FOLK, LOTRFaction.RED_MOUNTAINS, LOTRFaction.WIND, LOTRFaction.BLUE_MOUNTAINS};
        boolean hasRequiredAlignment = false;
        for (LOTRFaction faction : factions) {
            if (!(LOTRLevelData.getData(entityplayer).getAlignment(faction) >= 200.0f)) continue;
            hasRequiredAlignment = true;
            break;
        }
        if (!this.func_70631_g_()) {
            if (this.field_70153_n == null) {
                if (hasRequiredAlignment) {
                    ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
                    if (itemstack != null && itemstack.func_111282_a(entityplayer, (EntityLivingBase)this)) {
                        return true;
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        entityplayer.func_70078_a((Entity)this);
                    }
                    this.func_70624_b(null);
                    this.func_70661_as().func_75499_g();
                    return true;
                }
                if (!this.field_70170_p.field_72995_K) {
                    LOTRAlignmentValues.notifyAlignmentNotHighEnough(entityplayer, 200.0f, factions);
                }
                return true;
            }
            if (this.field_70153_n == entityplayer) {
                if (!this.field_70170_p.field_72995_K) {
                    entityplayer.func_70078_a(null);
                }
                return true;
            }
        }
        boolean flag = super.func_70085_c(entityplayer);
        if (this.func_70880_s() && !prevInLove) {
            this.func_70875_t();
        }
        return flag;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        EntityPlayer player;
        if (source.func_76346_g() instanceof EntityPlayer && !LOTRLevelData.getData(player = (EntityPlayer)source.func_76346_g()).getFriendlyFire()) {
            LOTRFaction[] factions;
            for (LOTRFaction faction : factions = new LOTRFaction[]{LOTRFaction.DURINS_FOLK, LOTRFaction.RED_MOUNTAINS, LOTRFaction.WIND, LOTRFaction.BLUE_MOUNTAINS}) {
                if (!(LOTRLevelData.getData(player).getAlignment(faction) > 1.0f)) continue;
                return false;
            }
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.65);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    public boolean func_70877_b(ItemStack itemstack) {
        return itemstack != null && itemstack.func_77973_b() == Items.field_151015_O;
    }

    @Override
    public void func_70628_a(boolean flag, int i) {
        int meat = this.field_70146_Z.nextInt(4) + 1 + this.field_70146_Z.nextInt(1 + i);
        for (int l = 0; l < meat; ++l) {
            if (this.func_70027_ad()) {
                this.func_145779_a(LOTRMod.muttonCooked, 1);
                continue;
            }
            this.func_145779_a(LOTRMod.muttonRaw, 1);
        }
    }

    @Override
    public double clampChildHealth(double health) {
        return MathHelper.func_151237_a((double)health, (double)20.0, (double)55.0);
    }

    @Override
    public double clampChildJump(double jump) {
        return MathHelper.func_151237_a((double)jump, (double)0.4, (double)1.1);
    }

    public LOTREntityRam createChild(EntityAgeable parent) {
        LOTREntityRam child = new LOTREntityRam(this.field_70170_p);
        child.func_70873_a(-24000);
        return child;
    }

    public void fall(float distance, float damageMultiplier) {
    }

    @Override
    public double clampChildSpeed(double speed) {
        return MathHelper.func_151237_a((double)speed, (double)0.12, (double)0.42);
    }

    public String func_70639_aQ() {
        return "lotr:ram.say";
    }

    public String func_70621_aR() {
        return "lotr:ram.hurt";
    }

    public String func_70673_aS() {
        return "lotr:ram.death";
    }

    public String func_110217_cl() {
        return "lotr:ram.angry";
    }
}

